/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.effect.EnviedEffect;
import com.james.tinkerscalibration.effect.EnvyArmorEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorRetributionModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> RETRIBUTION = TConstruct.createKey((String)"retribution");
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "envy");

    public ArmorRetributionModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, ArmorRetributionModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(RETRIBUTION, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(RETRIBUTION, (Object)0);
            if (level > 0 && attacker instanceof LivingEntity) {
                LivingEntity attackerl = (LivingEntity)attacker;
                if (event.getAmount() != 0.0f) {
                    int effectLevel = Math.min(7, ((TinkerEffect)Utils.envyEffect.get()).getLevel(living) + 1);
                    ((EnvyArmorEffect)((Object)((Object)Utils.envyArmorEffect.get()))).apply(living, 100, effectLevel, true);
                    ((EnviedEffect)((Object)((Object)Utils.envied.get()))).apply(attackerl, 100, effectLevel, true);
                }
            }
        });
    }
}

